import pygame, sys, os, math
from pygame.locals import *
import student_code_61


class ObstacleClass: #This defines the class Name
    """Defines the Obstacle class. More on object oriented programming in the next lecture"""
    xPos = 0 #Three class variables
    yPos = 0
    size = 0
    def __init__(self, xPos,yPos,size): #Constructor of the class
        self.xPos = xPos
        self.yPos = yPos
        self.size = size    

def redraw_arena(arena):
    """Redraws the arena in White"""
    arena.fill((255,255,255))
    
def text_objects(text, font):
    textSurface = font.render(text, True, (0,0,0))
    return textSurface, textSurface.get_rect()

def draw_button(screen,xPos,yPos,width,height,text,action=None):
     #### Draw a Button
    buttonX=xPos
    buttonY=yPos
    buttonSizeX=width
    buttonSizeY=height
    button = pygame.Rect(buttonX, buttonY, buttonSizeX, buttonSizeY)
    mouse = pygame.mouse.get_pos()
    click = pygame.mouse.get_pressed()
    ##Color it according to mouse positon
    if buttonX < mouse[0] < buttonX+buttonSizeX and buttonY < mouse[1] < buttonSizeY:
        pygame.draw.rect(screen, (40,174,157),button)
        if click[0] == 1 and action != None:
            action()
    else:
        pygame.draw.rect(screen, (24,95,86),button)
        
    smallText = pygame.font.Font("freesansbold.ttf",20)
    textSurf, textRect = text_objects(text, smallText)
    textRect.center = ( buttonX+buttonSizeX/2.0, buttonY+buttonSizeY/2.0)
    screen.blit(textSurf, textRect)

def rotate_player_to_angle(player_image, angle,curPosX,curPosY):
    """Rotate a Surface and translates its position."""
    rot_sprite = pygame.transform.rotozoom(player_image, angle,1)
    rect = rot_sprite.get_rect(center=(curPosX,curPosY))
    screen.blit(rot_sprite, rect)
    return rot_sprite


def draw_square(arena,targetPosX,targetPosY,color=(0,0,0),size = 10):
    """Draws a square at PosX and PosY with given size and color """
    target = pygame.Rect(targetPosX-(size/float(2)), targetPosY-(size/float(2)), size, size)
    pygame.draw.rect(arena, color, target)

def draw_line(arena,start_posX,start_posY,end_posX,end_posY,color = (0,0,0),strength=5):
    """Draws a line from one point to another"""
    pygame.draw.line(arena, color, (start_posX,start_posY), (end_posX,end_posY),strength)

def calculate_angle_to_target(playerPosX,playerPosY,targetPosX,targetPosY):
    """Calculate the Angle between two points"""
    deltaX = float(targetPosX - playerPosX)
    deltaY = float(targetPosY - playerPosY)
    
    hypo = math.sqrt(deltaX**2 + deltaY**2)
    angleRadians = math.asin(deltaY/hypo)
    if deltaX <0 and deltaY < 0:
        angleRadians = math.pi - angleRadians
    elif deltaX <0 and deltaY > 0:
        angleRadians = math.pi- angleRadians
    elif deltaX > 0 and deltaY > 0:
        angleRadians = angleRadians
    elif deltaX > 0 and deltaY < 0 :
        angleRadians = angleRadians  
    
    
    return math.degrees(angleRadians)
    

def getDistance(x1,y1,x2,y2) :
    """Calculate the distance between two points"""
    return math.sqrt(math.pow(x1-x2,2) + math.pow(y1-y2,2))

def get_norm(x,y):
    """Calculate the norm of a vector of two points"""
    return math.sqrt(x*x+y*y)#

def calculateSensorPositions(screen,currentHeading,currentPosX,currentPosY,sensorLeft=True):
    """Calculates the current position of a sensor given a vehicle heading and position"""
    sensorX = 0
    sensorY = 0
    #Position the Sensors

    dirX = math.cos(math.radians(currentHeading))
    dirY = math.sin(math.radians(currentHeading*-1)) #Y-Axis is flipped
    
    midline_x = currentPosX + 50*dirX 
    midline_y  = currentPosY+ 50*dirY
    #Calculate the Position between the Sensors!
    
    #Calculate Orthogonal Vectors to move Sensor 
    orth_dirX = 0
    orth_dirY = 0
    if dirX == 0:
        orth_dirX = 1
        orth_dirY = 0
    elif dirY == 0:
        orth_dirX=0
        orth_dirY=1
    else :
        if dirX * dirY >0 :
            orth_dirX = -1/float(dirX)
            orth_dirY = 1/float(dirY)
        else :
            orth_dirX = 1/float(dirX)
            orth_dirY = -1/float(dirY)
    
    orthoNorm = get_norm(orth_dirX,orth_dirY)
    orth_dirX = orth_dirX / float(orthoNorm)
    orth_dirY = orth_dirY / float(orthoNorm)
    
    sensorDistance = 15
    
    #Position the Sensor at Midline + OrthVector
    if sensorLeft :
        sensorX = midline_x +sensorDistance*orth_dirX*-1
        sensorY = midline_y +sensorDistance*orth_dirY*-1
        color = (255,0,0)
    else :
        sensorX = midline_x +sensorDistance*orth_dirX
        sensorY = midline_y +sensorDistance*orth_dirY
        color = (0,255,0)
    
    
    draw_square(screen,sensorX,sensorY,color)


    return (sensorX,sensorY)    

def getSensorReadings(screen,currentHeading,currentPosX,currentPosY,obstacleList):
    """Get the responses for both sensors by checking their orientation and distance towards obstacles"""
    #Sum over all obstacle    
    leftStrength = 0
    rightStrength = 0
    
    #Receive the Sensor Strength
    sensor1 = calculateSensorPositions(screen,currentHeading,currentPosX,currentPosY,True)
    sensor1_x = sensor1[0]
    sensor1_y = sensor1[1]
    sensor2 = calculateSensorPositions(screen,currentHeading,currentPosX,currentPosY,False)
    sensor2_x = sensor2[0]
    sensor2_y = sensor2[1]
    
    for obstacle in obstacleList:
        #Calculate the angle between Sensor and Obstacle
        glob_angle_to_obstacle_s1 = calculate_angle_to_target(sensor1_x,sensor1_y,obstacle.xPos,obstacle.yPos) *-1
        glob_angle_to_obstacle_s2 = calculate_angle_to_target(sensor2_x,sensor2_y,obstacle.xPos,obstacle.yPos) *-1

        #Convert Player Heading to -180 and +180
        currentHeading = currentHeading % 360
        newHeading = 0
        if currentHeading > 180:
            newHeading = currentHeading - 360
        else:
            newHeading = currentHeading

        #Calculate the Angle Difference between the Current Heading and the Global Heading
        angle_difference_s1 = newHeading - glob_angle_to_obstacle_s1
        angle_difference_s2 = newHeading - glob_angle_to_obstacle_s2
        
        #Check if the Obstacle is in the Orientation of the Sensor
        if abs(angle_difference_s1) < 60:
            d_s1 = getDistance(sensor1_x,sensor1_y,obstacle.xPos,obstacle.yPos)
            lStrength =  1000 / float(d_s1) 
            draw_line(screen,sensor1_x,sensor1_y,obstacle.xPos,obstacle.yPos,(255,0,0),int(lStrength))
            leftStrength += lStrength

        if abs(angle_difference_s2) < 60:
            d_s2 = getDistance(sensor2_x,sensor2_y,obstacle.xPos,obstacle.yPos)
            rStrength = 1000 / float(d_s2) 
            draw_line(screen,sensor2_x,sensor2_y,obstacle.xPos,obstacle.yPos,(0,255,0),int (rStrength))
            rightStrength +=rStrength

    
    return (leftStrength,rightStrength)

def refresh():
    global playerPosX,playerPosY,playerHeading
    print("Refreshing:" +str(playerPosX))
    playerPosX=100
    playerPosY = 295
    playerHeading = 1
    
    global obstacleList 
    obstacleList = []
    
def play_pause():
    global isRunning
    isRunning = not isRunning
    print(isRunning)
    
    
################  The real program starts here!    
playerPosX = 100 #We define initial Position and Heading
playerPosY = 295
playerHeading = 1

isRunning= True

#Create a single Obstacle and add it to the list
obstacle1 = ObstacleClass(500,300,10)  #Be aware that this obstacle is slightly below the player
obstacleList = [obstacle1]

refreshButtonPosX = 5
refreshButtonPosY =5
refreshButtonWidth = 100
refreshButtonHeight = 50

playButtonPosX = 110
playButtonPosY =5
playButtonWidth = 125
playButtonHeight = 50



### Usual pygame initialization
pygame.init()
screen = pygame.display.set_mode((800, 600))
screen.fill((255,255,255))
player_original = pygame.image.load(os.path.join("braitenberg.png"))
player_original.convert()




while True:
    ## We want to react to some of pygames automatic events
    for event in pygame.event.get():
            if event.type == QUIT: ### React to a click on the X-Button
                pygame.quit()
                sys.exit()
            elif event.type == pygame.MOUSEBUTTONUP: #React to a click of the Mouse
                mousex, mousey = event.pos #Get the mouse position
                if refreshButtonPosX < mousex < refreshButtonPosX+refreshButtonWidth and  refreshButtonPosY < mousey < refreshButtonPosY+refreshButtonHeight:
                    refresh()
                elif playButtonPosX < mousex < playButtonPosX+playButtonWidth and  playButtonPosY < mousey < playButtonPosY+playButtonHeight:
                    play_pause()
                else:
                    obstacleList.append(ObstacleClass(mousex,mousey,10)) #Append a new obstacle to the list. Position it at the clicked position.


    redraw_arena(screen) #Always draw the background first

    if isRunning:
        #Receive sensor values and store them in sensorLeft and sensorRight
        sensorValues = getSensorReadings(screen,playerHeading,playerPosX,playerPosY,obstacleList)
        sensorLeft= sensorValues[0] 
        sensorRight= sensorValues[1]     
        
        ################Put in your own relation between sensor values and angle change###############
        angleChange =   student_code_61.calc_angle_change(playerHeading,sensorLeft,sensorRight)
        ################The angle change will be applied by adding it to the current Heading###############
        playerHeading = playerHeading + angleChange*0.1
            
       
    	#Calculate the direction vector that points in the vehicle's heading direction
        dirX = math.cos(math.radians(playerHeading))
        dirY = math.sin(math.radians(playerHeading*-1))
        
        #Change the Position of the vehicle in the heading direction using a constant movement speed
        movementSpeed = 1
        playerPosX = playerPosX + movementSpeed * dirX
        playerPosY = playerPosY + movementSpeed * dirY     
        
    ### Apply the rotation and translation to the vehicle image
    rotate_player_to_angle(player_original,playerHeading,playerPosX,playerPosY)	
    
    #Draw all obstacles to visualize them
    for obstacle in obstacleList:
        draw_square(screen,obstacle.xPos,obstacle.yPos,(0,0,255),obstacle.size)
	
    ### Draw a button to refresh
    draw_button(screen,refreshButtonPosX,refreshButtonPosY,refreshButtonWidth,refreshButtonHeight,"Reload!")
    draw_button(screen,playButtonPosX,playButtonPosY,playButtonWidth,playButtonHeight,"Play/Pause!")
	
    pygame.display.flip() #Display all the new drawings
    pygame.time.delay(20) #Minimal delay to have a smooth simulation   
pygame.quit()
