function runalgo(folder, logit, dimensions, functions, instances, bb_1, ss1_1, cmares, ...
    ss1_2, gen1_1, gen1_2, mu2, mu3, t2, doubleT_gen1, t3, ...
    iter0, s0, cmares_lp, cmares_itp, cmares_b, lambda_min)
% Runs the SMS-EMOA on the bbob-biobj test suite.
%
% This example code allows also for easy implementation of independent
% restarts by simply increasing NUM_OF_INDEPENDENT_RESTARTS and setting
% opts.useOCD = true within my_smsemoa.m.
%

% TO MAKE MEX FILES:
% mex mocma.cc *.c *.cpp

% TO MAKE A STANDALONE APP
% mcc -mv runalgo.m -a *.m

%profile on

more off; % to get immediate output in Octave

setenv('LC_ALL','C')    % http://de.mathworks.com/matlabcentral/answers/126994-locale-system-error

folder 
dimensions 
instances 
functions 
logit = str2double(logit) 
bb_1 = str2double(bb_1) 
ss1_1 = str2double(ss1_1) 
cmares = str2double(cmares) 
ss1_2 = str2double(ss1_2) 
gen1_1 = str2double(gen1_1)
gen1_2 = str2double(gen1_2)
mu2 = str2double(mu2) 
mu3 = str2double(mu3) 
t2 = str2double(t2) 
doubleT_gen1 = str2double(doubleT_gen1) 
t3 = str2double(t3) 
iter0 = str2double(iter0) 
s0 = str2double(s0)
cmares_lp = str2double(cmares_lp) 
cmares_itp = str2double(cmares_itp) 
cmares_b = str2double(cmares_b)
lambda_min = str2double(lambda_min)

                                 
%%%%%%%%%%%%%%%%%%%%%%%%%
% Prepare Experiment    %
%%%%%%%%%%%%%%%%%%%%%%%%%     
mkdir(folder);
suite_name = 'bbob-biobj';
observer_name = suite_name;
resfolder = [folder '/myalgo'];
if (logit == 0)
    observer_options = [['result_folder: ' resfolder ' \'],...
                        'algorithm_name: SMS-EMOA \',...
                        'algorithm_info: "SMS-EMOA without restarts" \', ...
                        'log_level: COCO_INFO', ...
                        'log_nondominated: none'];      
else
    observer_options = [['result_folder: ' resfolder ' \'],...
                        'algorithm_name: SMS-EMOA \',...
                        'algorithm_info: "SMS-EMOA without restarts" \', ...
                        'log_level: COCO_INFO'];
end;    
cocostr = ['dimensions:' dimensions ' instance_indices:' instances ' function_indices:' functions];
suite = cocoCall('cocoSuite', suite_name, 'year: 2016', cocostr);
observer = cocoCall('cocoObserver', observer_name, observer_options);

% set log level depending on how much output you want to see, e.g. 'warning'
% for fewer output than 'info'.
cocoCall('cocoSetLogLevel', 'info');

global gsettings;
gsettings = [];
%%%%%%%%%%%%%%%%%%%%%%%%%
% Run Experiment        %
%%%%%%%%%%%%%%%%%%%%%%%%%

gsettings.s0 = s0;

while (1)
    % get next problem and dimension from the chosen suite:
    problem = cocoCall('cocoSuiteGetNextProblem', suite, observer);
	if (~cocoCall('cocoProblemIsValid', problem))
        break;
    end
    dimension = cocoCall('cocoProblemGetDimension', problem);
    
       
	my_f = @(x)cocoCall('cocoEvaluateFunction', problem, x);
    global gproblem;
    gproblem = my_f;
    gsettings.xvals = [];
    gsettings.fvals = [];
    gsettings.agfvals = [];

    xl = -5 * ones(1, dimension);
    xu = 5 * ones(1, dimension);
    seedval = 1;

	mocma('myfuncbi', 'cmacall', dimension, xl, xu, seedval, bb_1, ss1_1, cmares, ss1_2, gen1_1, ...
            gen1_2, mu2, mu3, t2, doubleT_gen1, t3, cmares_lp, cmares_itp, cmares_b, iter0, lambda_min);
end

cocoCall('cocoObserverFree', observer);
cocoCall('cocoSuiteFree', suite);

%profile viewer