

#include "utils.h"

#include <iostream> 
#include <iomanip>
#define USEMEX

#ifdef USEMEX
#include "mex.h"
mxArray *xval[1], *fval[1], *xval2[1], *fval2[1];
#else
#include "coco.h"
static coco_problem_t *PROBLEM;
#endif

using namespace std;


int RunType = -1;
int NMULT = 1;

typedef void(*evaluate_function_t)(const double *x, double *y);
evaluate_function_t bbevaluate;

int gdim = 2;
int gmuMO = 1;
//int gT = 100000000;
double al = 0.5;


//  // MEX
char* functionname;
char* cmacallname;

typedef void(*mymatlabfunc)(long int *, double *, double *);


RNG RNG::globalRng;
DiscreteUniform Rng::discrete;
Uniform         Rng::uni;
Normal          Rng::gauss;

void Rng::seed(long s)
{
	discrete.seed(s);
	uni.seed(s);
	gauss.seed(s);
}


#ifdef USEMEX

void fffunc(int dim, double* x, double * f)
{
	double *xx = mxGetPr(xval[0]);
	int notDouble = 0;
	for (int i = 0; i < dim; i++)
	{
		xx[i] = x[i];
		if (xx[i] * 0 != 0)
		{
			f[0] = 1e+30;
			//f[1] = 1e+30;
			return;
		}
	}
	int ninputs = 1;
	int noutputs = 1;
	mexCallMATLAB(noutputs, fval, ninputs, xval, functionname);
	double *yy = mxGetPr(fval[0]);
	f[0] = yy[0];
	f[1] = yy[1];
	mxDestroyArray(fval[0]);
}
#endif

int main2(double  *xl, double  *xu, int seedval);
int ieval = 0;
int printfile = 0;
int itoteval = 0;


int myfunc(double* a, double* b)
{
#ifdef USEMEX
	fffunc(gdim, a, b); // MEX
#else
	coco_evaluate_function(PROBLEM, a, b);
#endif
	ieval++;
	itoteval++;
	return 1;
}

inline void calcFitness(IndividualMOO &ii)
{
	double f1 = 0, f2 = 0, penalty = 0; unsigned j;
	ChromosomeT< double >& dblchrom = dynamic_cast< ChromosomeT< double >& >(ii[0]);

	vector<double> point(dblchrom.size());
	vector<double> value(2);
	for (int i = 0; i < dblchrom.size(); i++)
		point[i] = dblchrom.at(i);
	// query the black box
	int result = myfunc(&point[0], &value[0]);
	f1 = value[0];
	f2 = value[1];

	ii.setUnpenalizedMOOFitnessValues(f1, f2);
	ii.setMOOFitnessValues(f1, f2);
}

struct xy
{
	double objs[2];
	vector<double> xvals;
};

vector<xy> xys;
vector<xy> gxys;

void myfuncagg(double* a, double* b)
{
	//	return evaluate(a, b);
	double objs[2];
	myfunc(a, (double*)objs);

	if (ieval == 1)	xys.clear();
	if (itoteval == 1)	gxys.clear();
	xy curxy;
	curxy.objs[0] = objs[0];
	curxy.objs[1] = objs[1];
	for (int i = 0; i < gdim; i++)
		curxy.xvals.push_back(a[i]);
	xys.push_back(curxy);
	gxys.push_back(curxy);

	objs[0] = ((objs[0]) / fabs(xys[0].objs[0]));
	objs[1] = ((objs[1]) / fabs(xys[0].objs[1]));
	*b = (al)*objs[0] + (1.0 - al)*objs[1];
}


#define MO_CMA_ES2	0




int flArch = 0;
int iParArch = 0;

double HypCurVal = 0;
double HypOldVal = 0;




FILE *fpt1;
int nEvaluations = 200000;

int nIters = 2000000;
int nRuns = 1;


#define MO_GENER_ORIG 1
#define MO_STEADY_ORIG 2

//#define ALGORITHM MO_STEADY_COMMA
int GlobalNtry = 0;
int WindowSize = 500;
int Hor = 100000;
double Cglob = 0.000;
double alphaC = 0.1;
int iZ = 0;
int nRewMax = 20;

double kC = 0.1;


int destdir = 7;

vector<double> GetMedian(IndividualMOO& pt1, IndividualMOO& pt2)
{
	vector<double> med;
	ChromosomeCMA& ch1 = dynamic_cast<ChromosomeCMA&>(pt1[0]);
	ChromosomeCMA& ch2 = dynamic_cast<ChromosomeCMA&>(pt2[0]);
	double min = -0.0;
	double max = 1.0;
	double coef = 0.5 + 0.5 * Rng::gauss(0, 1); //
	//coef = min + (max - min)*Rng::uni(0, 1);
	for (int i = 0; i<ch1.n; i++)
	{
		//		double coef = 0.5;
		//coef = 0.5 + 0.125 * Rng::gauss(0, 1);
		double cur_coef = coef;
		//if (rand() / (float)RAND_MAX < 0.5)				cur_coef = 0;
		//else											cur_coef = 1;
		double val = ch1[i] + cur_coef * (ch2[i] - ch1[i]);
		med.push_back(val);
	}
	return med;
}

void GenerateMedian(PopulationMOO& pop, int muMo, int iChild, int iParent)
{

	int limRank1 = -1;
	for (int i = 0; i<muMo; i++)
		if ((pop[i].getMOORank() == 2) && (limRank1 == -1))
			limRank1 = i;
	if (limRank1 == -1)	limRank1 = muMo;

	std::vector<double> f1s;
	if (limRank1 > 1)
	{
		for (int i = 0; i < limRank1; i++)
			f1s.push_back(pop[i].getMOOFitness(0));
	}
	pop[iChild] = pop[rand() % limRank1];
	limRank1 = muMo;
	int p1 = rand() % limRank1;
	int p2 = rand() % limRank1;
	pop[iChild] = pop[p1];
	double mindf1 = 1e+30;
	dvector	vals;

	for (int i = 0; i < limRank1; i++)
	{
		//	double df1 = f1s.push_back(pop[i].getMOOFitness(0)) - f1s.push_back(pop[i].getMOOFitness(limRank1));
		vals.push_back(pop[i].getMOOFitness(0));
	}
	dvector i_arr;
	dvector	sorted = vals;
	sorted.Sort(&sorted, &i_arr, true);
	/*
	int p2 = p1 + 1;
	if (p2 == limRank1)
	p1 = p2 - 1;
	if (p2 == 1)	p1 = 1;
	*/

	//	vector<double> med = GetMedian(pop[0], pop[1]);
	vector<double> med = GetMedian(pop[p1], pop[p2]);
	for (int i = 0; i<med.size(); i++)
		static_cast< ChromosomeCMA& >(pop[iChild][0])[i] = med.at(i);

	int n = gdim;
	for (int i = 0; i < n; i++) {
		for (int j = 0; j < n; j++) {
			static_cast< ChromosomeCMA& >(pop[iChild][0]).C(i, j) = 0.5 * static_cast<ChromosomeCMA&>(pop[p1][0]).C(i, j) +
				0.5 * static_cast<ChromosomeCMA&>(pop[p2][0]).C(i, j);
		}
	}
	static_cast<ChromosomeCMA&>(pop[iChild][0]).sigma = 0.5 * static_cast<ChromosomeCMA&>(pop[p1][0]).sigma +
		0.5 * static_cast<ChromosomeCMA&>(pop[p2][0]).sigma;
}

void myb(double  *xl, double  *xu, long int maxfevals)
{
	long int dim = gdim;
	double ftarget = -1e+100;
	double  *x = new double[dim];
	double  *dx = new double[dim];
	double rhoend = 1e-60;
	long int npt = dim + 2;
	double xtol_rel = 1e-20;
	double ftol_rel = 1e-3;
	double ftol_abs = 1e-20;

	int ilaunch = 0;
	double als[] = { 0.5, 0.0, 1.0, 0.95, 0.9, 0.85, 0.8, 0.75, 0.7, 0.65, 0.6, 0.55, 0.5,
		0.45, 0.4, 0.35, 0.3, 0.25, 0.2, 0.15, 0.1, 0.05, 0.0 };

	while (itoteval < maxfevals)
	{
		int maxfevals_loc = 5 * dim;
		if (ilaunch == 0)
		{
			for (int i = 0; i < dim; i++)
			{
				x[i] = xl[i] + 0.5 * (xu[i] - xl[i]);
				dx[i] = 0.3 * (xu[i] - xl[i]);
			}
			ftol_rel = 1e-3;
		}
		else
		{
			for (int i = 0; i < dim; i++)
			{
				dx[i] = 0.1 * (xu[i] - xl[i]);
			}
			ftol_rel = 1e-4;
			if (ilaunch < 23)	al = als[ilaunch];
			else				al = Rng::uni(0, 1.0);
		}
		ilaunch++;
		mexFunctionBobyqa(dim, maxfevals_loc, ftarget, x, rhoend, npt, xl, xu, dx, xtol_rel, ftol_rel, ftol_abs, myfuncagg);
	}

	delete[] x;
	delete[] dx;
}



void Iteration(PopulationMOO &pop, int ALGORITHM, int t, unsigned int &muMo, unsigned int &lambdaMo, 
unsigned int incT, unsigned int &totevals, double* xtoinject, int &inject)
{
	double probCrossoverSSMOCMA = 0.1;
	int isCROSSOVER = 0;
	vector<int>	Parents;

	if (ALGORITHM == MO_STEADY_ORIG)
	{
		int iParent = Rng::discrete(0, muMo - 1);
		Parents.push_back(iParent);
		pop[muMo] = pop[iParent];
		static_cast< ChromosomeCMA& >(pop[muMo][0]).mutate();

		if (Rng::uni(0, 1.0) < probCrossoverSSMOCMA)
		{
			isCROSSOVER = 1;
			GenerateMedian(pop, muMo, muMo, iParent);
		}
		if (0)
		{
		
		}
		else 
		{
			if (inject == 1)
			{
				ChromosomeT< double >& dblchrom = dynamic_cast< ChromosomeT< double >& >(pop[muMo][0]);
				for (int j = 0; j < gdim; j++)
					dblchrom[j] = xtoinject[j];
				inject = 0;	
			}
		}
		calcFitness(pop[muMo]);
		totevals++;
	}

	if (ALGORITHM == MO_GENER_ORIG)
		for (int i = 0; i<lambdaMo; ++i)
		{
		pop[muMo + i] = pop[i % muMo];
		Parents.push_back(i%muMo);
		static_cast< ChromosomeCMA& >(pop[muMo + i][0]).mutate();
		if (Rng::uni(0, 1.0) < probCrossoverSSMOCMA)
		{
		//	isCROSSOVER = 1;
		//	GenerateMedian(pop, muMo, muMo + i, muMo + i);
		}
		calcFitness(pop[muMo + i]);
		totevals++;
		}

	pop.SMeasure();

	bool childIsBetter = PopulationMOO::compareRankShare(&pop[muMo], &pop[Parents.at(0)]);

	if ((ALGORITHM == MO_GENER_ORIG))
	{
		for (int i = 0; i<lambdaMo; i++) {
			bool childIsBetter = PopulationMOO::compareRankShare(&pop[i + muMo], &pop[i%muMo]);
			childIsBetter = PopulationMOO::compareRankShare(&pop[i + muMo], &pop[i%muMo]);
			(static_cast<ChromosomeCMA&>(pop[i%muMo][0])).updateLambdaSucc(childIsBetter);
			(static_cast<ChromosomeCMA&>(pop[i + muMo][0])).updateLambdaSucc(childIsBetter);
		}
	}
	if (((ALGORITHM == MO_STEADY_ORIG)) && (isCROSSOVER == 0))
	{
		(static_cast<ChromosomeCMA&>(pop[muMo][0])).updateLambdaSucc(childIsBetter);
		(static_cast<ChromosomeCMA&>(pop[Parents.at(0)][0])).updateLambdaSucc(childIsBetter);

		(static_cast<ChromosomeCMA&>(pop[muMo][0])).updateGlobalStepsize();
		(static_cast<ChromosomeCMA&>(pop[Parents.at(0)][0])).updateGlobalStepsize();
	}

	std::sort(pop.begin(), pop.end(), PopulationMOO::compareRankShare);

	if ((ALGORITHM == MO_STEADY_ORIG))
	{
		for (int i = 0; i<muMo; i++)
		{
			ChromosomeCMA& c = static_cast<ChromosomeCMA&>(pop[i][0]);
			if (c.covarianceUpdateNeeded())
			{
				c.updateCovariance();
				//cout << c.getCondition() << '\t';
			}
		}
	}

	if (ALGORITHM == MO_GENER_ORIG)
		for (int i = 0; i<muMo; i++) {
		ChromosomeCMA& c = static_cast<ChromosomeCMA&>(pop[i][0]);
		if (c.covarianceUpdateNeeded()) c.updateCovariance();
		c.updateGlobalStepsize();
		}

	double sumit = 0;
	int ncross = 0;
	
	if (ncross > 0)
		sumit = sumit / ncross;
	sumit = t - sumit;
	

	if (t % incT == 0)
	{
		//cout << t << '\t' << muMo << '\t' << ncross << '\t' << sumit << '\n';
		for (int l = 0; l < muMo; l++)
		{
			double Share = pop[l].getMOOShare();
			//if ((l == 2) || (l == muMo-1))
			//	cout << Share << '\t';
			//if (it > 0)
			{
				//sumit += it;
				//ncross++;
			}
		}
		//cout << '\n';

		//muMo++;
		muMo = muMo + 1;
		if (ALGORITHM == MO_GENER_ORIG)
			lambdaMo = muMo;
		//cout << muMo << '\n';
		int lambdaCMA = 1;
		int FullPopSize = muMo + lambdaMo*lambdaCMA;
		pop.resize(FullPopSize);
	}
}

void initPop(PopulationMOO& pop, int ALGORITHM, int paramDimension, double paramsigma,
	ChromosomeT<double> lower, ChromosomeT<double> upper, vector<double> stdv,
	int lambdaCMA, int muMo, double paramsigmalower, int insertoldbest, IndividualMOO prot)
{
	pop.setMinimize();
	pop.setNoOfObj(2);

	// get best hypervolume-rank solutions from old runs by e.g. bobyqa 
	int gmu = gxys.size();
	vector<int> selidxs;
	if (insertoldbest)
	{
		PopulationMOO poptmp(gmu, prot);
		poptmp.setMinimize();
		poptmp.setNoOfObj(2);

		for (int i = 0; i < gmu; i++)
		{
			poptmp[i].setUnpenalizedMOOFitnessValues(gxys[i].objs[0], gxys[i].objs[1]);
			poptmp[i].setMOOFitnessValues(gxys[i].objs[0], gxys[i].objs[1]);
			poptmp[i].setID(i);
		}
		poptmp.SMeasure();
		std::sort(poptmp.begin(), poptmp.end(), PopulationMOO::compareRankShare);

		for (int i = 0; i < gmu; i++)
			selidxs.push_back(poptmp[i].getID());
	}

	for (int i = 0; i < muMo; i++)
	{
		(dynamic_cast<ChromosomeCMA&>(pop[i][0])).init(paramDimension, stdv, paramsigma, lower, upper, lambdaCMA, paramsigmalower);
		if ((ALGORITHM == MO_STEADY_ORIG) && (insertoldbest))	// use old best x-values
		{
			ChromosomeT< double >& dblchrom = dynamic_cast< ChromosomeT< double >& >(pop[i][0]);
			if (i < selidxs.size())
				for (int j = 0; j < paramDimension; j++)
					dblchrom[j] = gxys[selidxs[i]].xvals[j];
		}
	}
}

int main2(double  *xl, double  *xu, int seedval, int insertoldbest,
	unsigned int muMo_ss1, unsigned int lambdaMo_ss1, unsigned int incT_ss1,
	unsigned int muMo_gen1, unsigned int lambdaMo_gen1, unsigned int incT_gen1, unsigned int doubleT_gen1,
	int ss1_1, int cmares, int ss1_2, int gen1_1, int gen1_2, 
	double cmares_lp, double cmares_itp, double cmares_b, int iter0, int lambda_min)
{
	unsigned      i, t, T;



	int paramSeed = seedval;
	int paramArchiveSize = 1;
	double paramsigma = 2.0;
	double paramsigmalower = 0;
	int paramOffSize = 1;
	if (insertoldbest)
		paramsigma = 0.5;
	int paramDimension = gdim;
	//  param.Dimension = 5;



	Rng::seed(seedval);				//Measurements


	// create vector of parameter bounds for initialization and constraint handling
	vector<double>      stdv(paramDimension);
	ChromosomeT<double> lower(paramDimension), upper(paramDimension);
	for (i = 0; i < gdim; ++i) {
		lower[i] = xl[i];		upper[i] = xu[i];		stdv[i] = 1;
	}
	ChromosomeCMA chrom(paramDimension);
	IndividualMOO prot(chrom);
	unsigned int lambdaCMA = 1;


	int ALGORITHM;

	// init mocma-ss1
	PopulationMOO pop_ss1(muMo_ss1 + lambdaMo_ss1*lambdaCMA, prot);
	insertoldbest = 1;
	initPop(pop_ss1, MO_STEADY_ORIG, paramDimension, paramsigma, lower, upper, stdv, lambdaCMA, muMo_ss1, paramsigmalower, insertoldbest, prot);

	// init mocma-gen1
	PopulationMOO pop_gen1(muMo_gen1 + lambdaMo_gen1*lambdaCMA, prot);
	insertoldbest = 0;
	initPop(pop_gen1, MO_GENER_ORIG, paramDimension, paramsigma, lower, upper, stdv, lambdaCMA, muMo_gen1, paramsigmalower, insertoldbest, prot);

	// evaluate ss1 
	unsigned int totevals_ss1 = 0;
	for (i = 0; i < muMo_ss1; i++)
	{
		calcFitness(pop_ss1[i]);
		totevals_ss1++;
	}

	int t_ss1 = 0;
	int inject = 0;
	
	while (itoteval < ss1_1)
	{
		Iteration(pop_ss1, MO_STEADY_ORIG, t_ss1, muMo_ss1, lambdaMo_ss1, incT_ss1, totevals_ss1, NULL, inject);
		t_ss1++;
	}


	int gen_init = 0;
	int t_gen1 = 0;


	//	for (int i = 0; i<10; i++)
	int tot_evals = 0;
	int maxtot_evals = cmares;
	int ss1tot_evals = 0;
	
	double* bestx_tmp = new double[gdim]; 

	unsigned int totevals_gen1 = 0;
	int ilaunch = 0;
	int stop_ss = 0;
	int stop_gen = 0;
	while (tot_evals < maxtot_evals)
	{
		int lambda_max = lambda_min * pow(cmares_lp, double(ilaunch));
		int lambda = lambda_min * pow(double(lambda_max) / double(lambda_min), cmares_b * Rng::uni(0, 1));
		int maxiter = iter0 * pow(cmares_itp, double(ilaunch));


#ifdef USEMEX
		// CALL restartCMA
		int ninputs = 1;
		int noutputs = 1;
		double *in = mxGetPr(xval2[0]);
		double in_aggr = Rng::uni(0, 1);		in[0] = in_aggr;
		double in_lambda = lambda;				in[1] = in_lambda;
		double in_maxiter = maxiter;			in[2] = in_maxiter;
		double in_dim = gdim;				in[3] = in_dim;
		double in_maxevals = maxtot_evals - tot_evals;			in[4] = in_maxevals;
		double in_icall = 0;				in[5] = in_icall;
		mexCallMATLAB(noutputs, fval2, ninputs, xval2, cmacallname);
		double *yy = mxGetPr(fval2[0]);
		int loc_evals = yy[0];
		for (int j=0; j<gdim; j++)
			bestx_tmp[j] = yy[1+j];
		ilaunch++;
		
		// inject it as the worst?
		for (int j=0; j<gdim; j++)
			bestx_tmp[j] = yy[1+j];
		inject = 1;	
#else
		int loc_evals = 10; // emulate call to restartCMA
#endif
		tot_evals = tot_evals + loc_evals;
		while (((tot_evals >= gen1_1) && (tot_evals <= gen1_2) && (tot_evals - gen1_1 > totevals_gen1)) && (stop_gen == 0))
		{
			if (gen_init == 0)
			{
				gen_init = 1;
				for (i = 0; i < muMo_gen1; ++i)
					calcFitness(pop_gen1[i]);
				totevals_gen1 += muMo_gen1;
			}
			Iteration(pop_gen1, MO_GENER_ORIG, t_gen1, muMo_gen1, lambdaMo_gen1, incT_gen1, totevals_gen1, bestx_tmp, inject);
			

			if (t_gen1 % 100 == 0)
			{
				PopulationMOO pop_sum(muMo_gen1 + muMo_ss1, prot);
				for (int k = 0; k < muMo_gen1; k++)
				{
					pop_sum[k] = pop_gen1[k];
					pop_sum[k].setID(0);
				}
				for (int k = 0; k < muMo_ss1; k++)
				{
					pop_sum[muMo_gen1 + k] = pop_ss1[k];
					pop_sum[muMo_gen1 + k].setID(1);
				}
				pop_sum.SMeasure();
				std::sort(pop_sum.begin(), pop_sum.end(), PopulationMOO::compareRankShare);
				double sumrank_gen = 0;
				double sumrank_ss = 0;
				for (int k = 0; k < muMo_gen1 + muMo_ss1; k++)
				{
					if (pop_sum[k].getID() == 0)
						sumrank_gen += k;
					else
						sumrank_ss += k;
				}
				sumrank_ss = (sumrank_ss / double(muMo_ss1)) / double(muMo_ss1 + muMo_gen1);
				sumrank_gen = (sumrank_gen / double(muMo_gen1) / double(muMo_ss1 + muMo_gen1));
				cout << sumrank_ss << '\t' << sumrank_gen << '\n';
				//if (sumrank_ss > 0.5)
				//	stop_ss = 1;
			}

			t_gen1++;
			if (t_gen1 > doubleT_gen1)
			{
				gen_init = 0;
				t_gen1 = 0;
				muMo_gen1 = muMo_gen1 * 2;
				lambdaMo_gen1 = muMo_gen1;
				int FullPopSize = muMo_gen1 + lambdaMo_gen1;
				pop_gen1.resize(FullPopSize);
				initPop(pop_gen1, MO_GENER_ORIG, paramDimension, paramsigma, lower, upper, stdv, lambdaCMA, muMo_gen1, paramsigmalower, insertoldbest, prot);
			}
		}

		if (stop_ss == 0)
		{
			if (tot_evals < ss1_2)
				for (int j = 0; j < loc_evals; j++)
				{
					if ((Rng::uni(0, 1.0) < 0.1) && (j > 0))
					{
						int indx = rand() % muMo_gen1;
						ChromosomeT< double >& dblchrom = dynamic_cast< ChromosomeT< double >& >(pop_gen1[indx][0]);
						for (int k=0; k<gdim; k++)
							bestx_tmp[k] = dblchrom[k];
						inject = 1;	
					}
					Iteration(pop_ss1, MO_STEADY_ORIG, t_ss1, muMo_ss1, lambdaMo_ss1, incT_ss1, totevals_ss1, bestx_tmp, inject);
					t_ss1++;
				}
			else
			{
				if (0)
				{			
					stop_gen = 1;
					if (tot_evals < 5*ss1_2)
						for (int j = 0; j < loc_evals; j++)
						{
							Iteration(pop_ss1, MO_STEADY_ORIG, t_ss1, muMo_ss1, lambdaMo_ss1, incT_ss1, totevals_ss1, bestx_tmp, inject);
							t_ss1++;
						}
				}
			}
		}
	}
	delete[] bestx_tmp;
	return(EXIT_SUCCESS);
}




#ifdef USEMEX
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
	functionname = mxArrayToString(prhs[0]);
	cmacallname = mxArrayToString(prhs[1]);
	int dim = (int)(mxGetScalar(prhs[2]));
	double  *xl = mxGetPr(prhs[3]);
	double  *xu = mxGetPr(prhs[4]);
	int seedval = (int)(mxGetScalar(prhs[5]));
	//int maxfevals = (int)(mxGetScalar(prhs[4]));
	int bb_1 = dim * (double)(mxGetScalar(prhs[6]));//
	int ss1_1 = dim * (double)(mxGetScalar(prhs[7]));//5000;	// SS1 first runs for ss1_1 evals
	int cmares = dim * (double)(mxGetScalar(prhs[8]));//gdim * 20000;		// CMARES then runs for cmares evals
	int ss1_2 = dim * (double)(mxGetScalar(prhs[9]));//gdim * 500;//5000;	// SS1 runs for ss1_2 evals when in parallel with CMARES
	int gen1_1 = dim * (double)(mxGetScalar(prhs[10]));//gdim * 5000;//5000;	// GEN1 starts when CMARES is at gen1_1 evals
	int gen1_2 = dim * (double)(mxGetScalar(prhs[11]));// GEN1 stops when CMARES is at gen1_1 evals 
	double gmuMO2 = (double)(mxGetScalar(prhs[12]));
	double gmuMO3 = (double)(mxGetScalar(prhs[13]));
	double gt2 = (double)(mxGetScalar(prhs[14]));
	int doubleT_gen1 = (int)(mxGetScalar(prhs[15]));
	double gt3 = (double)(mxGetScalar(prhs[16]));
	double cmares_lp = (double)(mxGetScalar(prhs[17]));
	double cmares_itp = (double)(mxGetScalar(prhs[18]));
	double cmares_b = (double)(mxGetScalar(prhs[19]));
	int iter0 = (int)(mxGetScalar(prhs[20]));
	int lambda_min = (int)(mxGetScalar(prhs[21]));
	
	xval[0] = mxCreateDoubleMatrix(1, dim, mxREAL);
	fval[0] = mxCreateDoubleMatrix(1, 2, mxREAL);

	xval2[0] = mxCreateDoubleMatrix(1, 10, mxREAL);
	fval2[0] = mxCreateDoubleMatrix(1, dim + 1, mxREAL);




	gdim = dim;
	{
		int iAlgo = 0;


		fflush(stdout);
		int ALGORITHM;
		int gT;
		ieval = 0;
		itoteval = 0;
		if (bb_1 > 0)	// bobyqa
			myb(xl, xu, bb_1);

		unsigned int muMo_ss1 = gmuMO2;//5;
		unsigned int lambdaMo_ss1 = 1;
		unsigned int incT_ss1 = gt2;//500;
		unsigned int muMo_gen1 = gmuMO3;//400;
		unsigned int lambdaMo_gen1 = muMo_gen1;
		unsigned int incT_gen1 = gt3;//3;

		main2(xl, xu, seedval, 1,
			muMo_ss1, lambdaMo_ss1, incT_ss1,
			muMo_gen1, lambdaMo_gen1, incT_gen1, doubleT_gen1,
			ss1_1, cmares, ss1_2, gen1_1, gen1_2,
			cmares_lp, cmares_itp, cmares_b, iter0, lambda_min);


		printf("Done!\n");
		fflush(stdout);
	}
}

#else

void runalgo(int dim)
{
	double  *xl = new double[dim];
	double  *xu = new double[dim];
	for (int i = 0; i < dim; i++)
	{
		xl[i] = -5.0;
		xu[i] = 5.0;
	}
	int seedval = 1;
	int bb_1 = dim * 10;//
	int ss1_1 = dim * 100;//5000;	// SS1 first runs for ss1_1 evals
	int cmares = dim * 2000;//gdim * 20000;		// CMARES then runs for cmares evals
	int ss1_2 = dim * 500;//gdim * 500;//5000;	// SS1 runs for ss1_2 evals when in parallel with CMARES
	int gen1_1 = dim * 0;//gdim * 5000;//5000;	// GEN1 starts when CMARES is at gen1_1 evals
	int gen1_2 = cmares;// GEN1 stops when CMARES is at gen1_1 evals 
	double gmuMO2 = 5;
	double gmuMO3 = 10;
	int doubleT_gen1 = 500;
	double gt2 = 1000;
	int iter0 = 100;
	int lambda_min = 50;

	double gt3 = 10000000000;

	double cmares_lp = 1.02;
	double cmares_itp = 1.02;
	double cmares_b = 2.0;

	gdim = dim;
	{
		int iAlgo = 0;


		fflush(stdout);
		int ALGORITHM;
		int gT;
		ieval = 0;
		itoteval = 0;
		if (bb_1 > 0)	// bobyqa
			myb(xl, xu, bb_1);

		unsigned int muMo_ss1 = gmuMO2;//5;
		unsigned int lambdaMo_ss1 = 1;
		unsigned int incT_ss1 = gt2;//500;
		unsigned int muMo_gen1 = gmuMO3;//400;
		unsigned int lambdaMo_gen1 = muMo_gen1;
		unsigned int incT_gen1 = gt3;//3;


		main2(xl, xu, seedval, 1,
			muMo_ss1, lambdaMo_ss1, incT_ss1,
			muMo_gen1, lambdaMo_gen1, incT_gen1, doubleT_gen1,
			ss1_1, cmares, ss1_2, gen1_1, gen1_2,
			cmares_lp, cmares_itp, cmares_b, iter0, lambda_min);


		printf("Done!\n");
		fflush(stdout);
	}

}

int main()
{
	{
		int RANDOM_SEED = 1;
		coco_random_state_t *random_generator = coco_random_new(RANDOM_SEED);

		/* Change the log level to "warning" to get less output */
		coco_set_log_level("info");

		printf("Running the example experiment... (might take time, be patient)\n");
		fflush(stdout);

		const char *suite_name = "bbob-biobj";
		const char *observer_name = "bbob-biobj";
		//example_experiment("bbob-biobj", "bbob-biobj", random_generator);
		size_t run;
		coco_suite_t *suite;
		coco_observer_t *observer;

		/* Set some options for the observer. See documentation for other options. */
		char *observer_options =
			coco_strdupf("result_folder: RS_on_%s "
			"log_nondominated: none "
			"algorithm_name: RS "
			"algorithm_info: \"A simple random search algorithm\"", suite_name);

		/* Initialize the suite and observer */
		suite = coco_suite(suite_name, "year: 2016", "dimension_indices:5 instance_indices:1");
		observer = coco_observer(observer_name, observer_options);
		coco_free_memory(observer_options);

		int iproblem = 1;
		int iinst = 1;
		/* Iterate over all problems in the suite */
		while ((PROBLEM = coco_suite_get_next_problem(suite, observer)) != NULL) {
			iproblem++;
			ieval = 0;
			itoteval = 0;
			size_t dimension = coco_problem_get_dimension(PROBLEM);

			runalgo(dimension);
		}

		coco_observer_free(observer);
		coco_suite_free(suite);

		/* Uncomment the line below to run the same example experiment on the bbob suite
		example_experiment("bbob", "bbob", random_generator); */

		printf("Done!\n");
		fflush(stdout);
	}
}

#endif
