function Fvalue = fgeneric(x, FUNC_ID, itrial, dataPath, PARAMS)

  global settings;
  
  if nargin < 1
    help('fgeneric');
    return;
  end
  if ischar(x)
    if strcmpi(x, 'initialize')
        settings.ievals = 0;
        settings.fbest = 1e+30;
        % HERE DEFINE YOUR TARGET F(X) 
        % IF f(x) IS BELOW TARGET F(X), THE ALGORITHM WILL STOP
        % NOTE: ALL PRINTED F(X) IS GIVEN W.R.T> TARGET F(X) AS F(X)-TARGET F(X)
        %settings.ftarget = 1e-10;
        Fvalue = 1;
        return;
    elseif strcmpi(x, 'finalize')       
        Fvalue = 1;
        return;
    elseif strncmpi(x, 'evaluations', 4)
        Fvalue = settings.ievals;
      return;
    elseif strcmpi(x, 'best') || strcmpi(x, 'fbest')
        Fvalue = settings.fbest;
      return;
    elseif strcmpi(x, 'ftarget')
        Fvalue = settings.ftarget;
      return;
    elseif strcmpi(x, 'maxEvals') || strcmpi(x, 'maxFunEvals')
        Fvalue = settings.maxevals;
  	return;
    end;
 end;  

 batchsize = size(x,2);
 for j=1:batchsize
     point = x(:,j)';
     N = numel(point);
     
     xnormalized = settings.gxmin + point.*(settings.gxmax - settings.gxmin);
     % HERE DEFINE YOUR FUNCTION f(point)
     %Fvalue(j) = 1e6.^((0:N-1)/(N-1)) * point.^2; % felli
     Fvalue(j) = genopt(xnormalized);
     % HERE DEFINE YOUR FUNCTION f(point)
     settings.ievals = settings.ievals + 1;
     if (Fvalue(j) < settings.fbest)
         settings.fbest = Fvalue(j);
         settings.xbest = x;
         disp([num2str(settings.ievals) ' ' num2str(settings.fbest)]);
     end;
 end;

 