
#
# This file is part of the supplementary material for the paper
#               "Limits of End-to-End Learning"
# submitted to ACML'2017, written by the anonymous authors.
#
# Anyone is free to copy, modify, publish, use, compile, sell, or
# distribute this software, either in source code form or as a compiled
# binary, for any purpose, commercial or non-commercial, and by any
# means.
#
# In jurisdictions that recognize copyright laws, the author or authors
# of this software dedicate any and all copyright interest in the
# software to the public domain. We make this dedication for the benefit
# of the public at large and to the detriment of our heirs and
# successors. We intend this dedication to be an overt act of
# relinquishment in perpetuity of all present and future rights to this
# software under copyright law.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
#
# For more information, please refer to <http://unlicense.org/>
#


from sys import argv
import math
import numpy as np
from keras.models import Model, Sequential
from keras.layers import Input, Dense, Activation, Flatten, Reshape, Lambda, Merge, merge, Convolution2D, MaxPooling2D, Dropout
from keras.optimizers import SGD, Adam
from keras.callbacks import Callback, History, EarlyStopping, ModelCheckpoint

# experiment settings
depth = 2
maxepochs = 10**8
repetitions = 10

if len(argv) > 1:
	depth = int(argv[1])

# module parameters
b = 4
B = 10

# sump settings
print('--------------------------------------------------------')
print(' # repetitions: ' + str(repetitions))
print('         depth: ' + str(depth))
print('--------------------------------------------------------')

# generate data
X = np.zeros((B, B))
Y = np.zeros((B, B))
for i in range(B):
	X[i, i] = 1.0
	Y[i, i] = 1.0

# stop when the task is solved
class StopWhenDone(Callback):
	def __init__(self):
		super(Callback, self).__init__()

	def on_epoch_end(self, epoch, logs={}):
		if logs.get('acc') > 0.999:
			self.model.stop_training = True

# experiments loop
num_success = 0
num_failure = 0
sum_accuracy = 0.0
num_epochs = []
for run in range(repetitions):
	print('experiment ' + str(run+1) + ' of ' + str(repetitions))
	np.random.seed(42 + run)

	# create network
	net = Sequential()

	# add modules
	for i in range(depth):
		net.add(Dense(units = b, input_dim = B if len(net.layers) == 0 else None, activation='sigmoid'))
		net.add(Dense(units = B, activation='softmax'))

	# compile
	net.compile(loss='categorical_crossentropy', optimizer='adadelta', metrics=['accuracy'])

	# train
	h = net.fit(X, Y, batch_size=B, epochs=maxepochs, verbose=0, callbacks=[StopWhenDone(), History()])
	acc = h.history.get('acc')
	print('  actual epochs: ' + str(len(acc)))
	print('       accuracy: ' + str(np.max(acc)))

	if acc[-1] > 0.999:
		num_success += 1
		num_epochs.append(len(acc))
	else:
		num_failure += 1
	sum_accuracy += np.max(acc)

print('')
print('--------------------------------------------------------')
print('SUMMARY:')
print(' * successes:   ' + str(num_success))
print(' *  failures:   ' + str(num_failure))
print(' *  accuracy:   ' + str(sum_accuracy / repetitions))
print(' *  # epochs: ' + (str(np.median(num_epochs)) if len(num_epochs) > 0 else '---') + '   (for successful runs)')
