
#
# This file is part of the supplementary material for the paper
#               "Limits of End-to-End Learning"
# submitted to ACML'2017, written by the anonymous authors.
#
# Anyone is free to copy, modify, publish, use, compile, sell, or
# distribute this software, either in source code form or as a compiled
# binary, for any purpose, commercial or non-commercial, and by any
# means.
#
# In jurisdictions that recognize copyright laws, the author or authors
# of this software dedicate any and all copyright interest in the
# software to the public domain. We make this dedication for the benefit
# of the public at large and to the detriment of our heirs and
# successors. We intend this dedication to be an overt act of
# relinquishment in perpetuity of all present and future rights to this
# software under copyright law.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
#
# For more information, please refer to <http://unlicense.org/>
#


from sys import argv
import math
import numpy as np
from PIL import Image
from keras.models import Sequential
from keras.layers import Dense, Activation, Flatten, Conv2D, MaxPooling2D
from keras.optimizers import SGD, Adam
from keras.callbacks import Callback, History, EarlyStopping
from keras.datasets import mnist
from keras.utils import np_utils
from keras import backend as K

# experiment settings
depth = int(argv[1])
earlystop = 20
repetitions = 10

# module parameters
b = 4
B = 10

# sump settings
print('--------------------------------------------------------')
print(' # repetitions: ' + str(repetitions))
print('         depth: ' + str(depth))
print('early stopping: ' + str(earlystop))
print('--------------------------------------------------------')

# load and prepare MNIST data
(X, Y), (XX, YY) = mnist.load_data()

if K.image_dim_ordering() == 'th':
	X = X.reshape(X.shape[0], 1, 28, 28)
	XX = XX.reshape(XX.shape[0], 1, 28, 28)
	input_shape = (1, 28, 28)
else:
	X = X.reshape(X.shape[0], 28, 28, 1)
	XX = XX.reshape(XX.shape[0], 28, 28, 1)
	input_shape = (28, 28, 1)

X = X.astype('float32')
XX = XX.astype('float32')
X /= 255
XX /= 255

Y = np_utils.to_categorical(Y, 10)
YY = np_utils.to_categorical(YY, 10)

sum_accuracy = 0.0
num_epochs = 0

for run in range(repetitions):
	np.random.seed(42 + run)

	# create network
	net = Sequential()

	# add the "basic MNIST network" module
	net.add(Conv2D(32, (5, 5), input_shape=input_shape, activation='relu'))
	net.add(MaxPooling2D(pool_size=(2, 2)))
	net.add(Conv2D(64, (5, 5), activation='relu'))
	net.add(MaxPooling2D(pool_size=(2, 2)))
	net.add(Flatten())
	net.add(Dense(200, activation='relu'))
	net.add(Dense(10, activation='softmax'))

	# add further modules
	for i in range(depth):
		net.add(Dense(units = b, input_dim = B if len(net.layers) == 0 else None, activation='sigmoid'))
		net.add(Dense(units = B, activation='softmax'))

	# compile
	net.compile(loss='categorical_crossentropy', optimizer='adadelta', metrics=['accuracy'])

	# train
	h = net.fit(X, Y, validation_data=(XX, YY), batch_size=10, epochs=1000000, verbose=1, callbacks=[History(), EarlyStopping(monitor='val_acc', min_delta=0, patience=earlystop, mode='max')])
	val_acc = h.history.get('val_acc')
	print('training epochs: ' + str(len(val_acc)) + '   accuracy: ' + str(np.max(val_acc)))
	print('')

	num_epochs += len(val_acc)
	sum_accuracy += np.max(val_acc)

print('')
print('--------------------------------------------------------')
print('SUMMARY:')
print(' * accuracy:   ' + str(sum_accuracy / repetitions))
print(' *   epochs:   ' + str(num_epochs   / repetitions))
